/*
 * Copyright (C) 1985-1992  New York University
 * 
 * This file is part of the Ada/Ed-C system.  See the Ada/Ed README file for
 * warranty (none) and distribution info and also the GNU General Public
 * License for more details.

 */

#define GEN

#include "hdr.h"
#include "vars.h"
#include "gvars.h"
#include "opdesc.h"

int opdesc_d_mode,opdesc_a_mode;
char *opdesc_name;

#ifdef OPDESC_TEST
/* define OPDESC_TEST for standalone test of opdesc*/
main()
{
	opdesc(260);
	printf("%d %d %s\n",opdesc_d_mode, opdesc_a_mode, opdesc_name);
}
#endif

void opdesc(int op)				/*;opdesc*/
{
	/* return paramters of opcode, as globals opdesc_d_mode, 
	 * opdesc_a_mode, opdesc_name
	 */

	static struct opdesc_ent {
		short op_d_mode, op_a_mode;
		char *op_name;
	} opara[] = {
		{  D_NONE, A_NONE, "nop"},
		{  D_NONE, A_IMM, "abort"},
		{  D_FIX, A_NONE, "abs"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_NONE, "activate"},
		{  D_NONE, A_BOTH, "activate_new"},
		{   0, 0, "" }, 
		{  D_FIX, A_NONE, "add"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_FIX, A_IMM, "add_immediate"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_NONE, "and"},
		{  D_NONE, A_NONE, "allocate"},
		{  D_NONE, A_BOTH, "allocate_copy"},
		{   0, 0, "" }, 
		{  D_NONE, A_NONE, "array_and"},
		{  D_NONE, A_NONE, "array_catenate"},
		{  D_NONE, A_NONE, "array_move"},
		{  D_NONE, A_NONE, "array_not"},
		{  D_NONE, A_NONE, "array_or"},
		{  D_NONE, A_NONE, "array_slice"},
		{  D_NONE, A_NONE, "array_xor"},
		{  D_NONE, A_ATTR, "attribute"},
		{  D_NONE, A_BOTH, "call"},
		{   0, 0, "" }, 
		{  D_NONE, A_PREDEF, "call_predef"},
		{  D_INT, A_NONE, "case"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_ALL, A_NONE, "compare"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_NONE, "compare_struc"},
		{  D_NONE, A_BOTH, "convert_to"},
		{   0, 0, "" }, 
		{  D_ALL, A_NONE, "create"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_ALL, A_NONE, "create_copy"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_NONE, "create_copy_struc"},
		{  D_NONE, A_BOTH, "create_task"},
		{   0, 0, "" }, 
		{  D_NONE, A_NONE, "create_struc"},
		{  D_NONE, A_NONE, "current_task"},
		{  D_NONE, A_NONE, "deallocate"},
		{  D_ALL, A_LOCAL, "declare"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_ALL, A_NONE, "deref"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_IMM, "discard_addr"},
		{  D_INT, A_NONE, "div"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_ALL, A_NONE, "duplicate"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_IMM, "end_activation"},
		{  D_INT, A_CODE, "end_for_loop"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_INT, A_CODE, "end_forrev_loop"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_NONE, "end_rendezvous"},
		{  D_NONE, A_NONE, "enter_block"},
		{  D_NONE, A_IMM, "entry_call"},
		{  D_NONE, A_NONE, "fix_mul"},
		{  D_NONE, A_NONE, "fix_div"},
		{  D_FLOAT, A_NONE, "float_add"},
		{   0, 0, "" }, 
		{  D_FLOAT, A_NONE, "float_compare"},
		{   0, 0, "" }, 
		{  D_FLOAT, A_NONE, "float_div"},
		{   0, 0, "" }, 
		{  D_FLOAT, A_NONE, "float_mul"},
		{   0, 0, "" }, 
		{  D_FLOAT, A_NONE, "float_neg"},
		{   0, 0, "" }, 
		{  D_FLOAT, A_NONE, "float_pow"},
		{   0, 0, "" }, 
		{  D_FLOAT, A_NONE, "float_sub"},
		{   0, 0, "" }, 
		{  D_FLOAT, A_NONE, "float_abs"},
		{   0, 0, "" }, 
		{  D_ALL, A_NONE, "indirect_move"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_ALL, A_BOTH, "indirect_pop"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_CODE, "install_handler"},
		{  D_NONE, A_NONE, "is_equal"},
		{  D_NONE, A_NONE, "is_less"},
		{  D_NONE, A_NONE, "is_greater"},
		{  D_NONE, A_NONE, "is_less_or_equal"},
		{  D_NONE, A_NONE, "is_greater_or_equal"},
		{  D_NONE, A_CODE, "jump"},
		{  D_NONE, A_CODE, "jump_if_false"},
		{  D_NONE, A_CODE, "jump_if_greater"},
		{  D_NONE, A_CODE, "jump_if_greater_or_equal"},
		{  D_NONE, A_CODE, "jump_if_less"},
		{  D_NONE, A_CODE, "jump_if_less_or_equal"},
		{  D_NONE, A_CODE, "jump_if_true"},
		{  D_NONE, A_NONE, "leave_block"},
		{  D_NONE, A_NONE, "link_tasks_declared"},
		{  D_NONE, A_EXCEPTION, "load_exception_register"},
		{  D_NONE, A_NONE, "membership"},
		{  D_INT, A_NONE, "mod"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_ALL, A_NONE, "move"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_INT, A_NONE, "mul"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_FIX, A_NONE, "neg"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_NONE, "not"},
		{  D_NONE, A_NONE, "or"},
		{  D_ALL, A_BOTH, "pop"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_BOTH, "pop_tasks_declared"},
		{   0, 0, "" }, 
		{  D_INT, A_NONE, "pow"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_ALL, A_BOTH, "push"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_BOTH, "push_effective_address"},
		{   0, 0, "" }, 
		{  D_ALL, A_IMM, "push_immediate"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_BOTH, "qual_discr"},
		{   0, 0, "" }, 
		{  D_NONE, A_BOTH, "qual_index"},
		{   0, 0, "" }, 
		{  D_NONE, A_BOTH, "qual_range"},
		{   0, 0, "" }, 
		{  D_NONE, A_BOTH, "qual_sub"},
		{   0, 0, "" }, 
		{  D_NONE, A_NONE, "raise"},
		{  D_NONE, A_NONE, "raise_in_caller"},
		{  D_NONE, A_BOTH, "record_move"},
		{   0, 0, "" }, 
		{  D_INT, A_NONE, "rem"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_LOCAL, "restore_stack_pointer"},
		{  D_ALL, A_LOCAL, "return"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_LOCAL, "return_struc"},
		{  D_NONE, A_LOCAL, "save_stack_pointer"},
		{  D_NONE, A_IMM, "select"},
		{  D_NONE, A_IMM, "selective_wait"},
		{  D_NONE, A_NONE, "compare_arrays"},
		{  D_NONE, A_IMM, "stmt"},
		{  D_FIX, A_NONE, "sub"},
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{   0, 0, "" }, 
		{  D_NONE, A_LOCAL, "subprogram"},
		{  D_NONE, A_NONE, "subscript"},
		{  D_NONE, A_IMM, "terminate"},
		{  D_NONE, A_EXCEPTION, "test_exception_register"},
		{  D_NONE, A_IMM, "timed_entry_call"},
		{  D_NONE, A_GLOBAL, "type_global"},
		{  D_NONE, A_GLOBAL, "type_local"},
		{  D_NONE, A_NONE, "uncreate"},
		{  D_NONE, A_LOCAL, "update"},
		{  D_NONE, A_LOCAL, "update_and_discard"},
		{  D_NONE, A_NONE, "wait"},
		{  D_NONE, A_NONE, "xor"},
		{  D_NONE, A_NONE, "exit_block"},
		{  D_NONE, A_IMM, "call_interface"},
		{  D_NONE, A_NONE, "check_rec_subtype"},
		{  D_PSEUDO, A_PSEUDO, "case_table"},
		{  D_PSEUDO, A_PSEUDO, "label"},
		{   0, 0, "" }, 
		{  D_PSEUDO, A_PSEUDO, "end"},
		{  D_PSEUDO, A_PSEUDO, "data"},
		{   0, 0, "" } 
	};

	opdesc_d_mode = opara[op].op_d_mode;
	opdesc_a_mode = opara[op].op_a_mode;
	opdesc_name = opara[op].op_name;
}
